#include "Tree.h"
#include "TreeList.h"
#include "Logger.h"

/*This Image is 37 pixels wide, 34 pixels high, and 8 bits deep*/
unsigned char bigmap_data[] = 
{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
0xFA, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFA, 0xFA, 0xFA, 0xFA, 0x00, 
0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0x00, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0x00, 0x00, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFA, 0xFA, 0xFA, 0xFA, 
0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0x00, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 
0xFA, 0xFA, 0xFA, 0x5D, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFA, 0xFA, 0xFA, 
0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0x5D, 0x5D, 
0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0x00, 0x1F, 0x1F, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 
0xFA, 0xFA, 0xFA, 0xFA, 0x5D, 0x5D, 0x5D, 0x00, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
0xF9, 0xF9, 0x1F, 0x1F, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0xFA, 0x5D, 
0x5D, 0x5D, 0x5D, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xF9, 0xF9, 0xF9, 0xF9, 
0x1F, 0x1F, 0xFA, 0xFA, 0xFA, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0x00, 0xFF, 0x00, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0x1F, 0x1F, 
0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x60, 0x01, 0x00, 0xF9, 
0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0x5D, 0x5D, 0x5D, 0x5D, 
0x5D, 0x5D, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0x00, 0x60, 0x60, 0x60, 0x01, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 
0xF9, 0xF9, 0xF9, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x01, 0x00, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x60, 0x60, 0x60, 
0x60, 0x01, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0x5D, 
0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x01, 0xA3, 0x00, 0x00, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x01, 0xF9, 0xF9, 
0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 
0x5D, 0x01, 0xA3, 0xA3, 0xA3, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x60, 0x60, 
0x60, 0x60, 0x60, 0x1B, 0x29, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 
0xF9, 0xF9, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x01, 0xA3, 0xA3, 0xA3, 
0xA3, 0xA3, 0x2E, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x1B, 0x60, 
0x00, 0x00, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0x5D, 0x5D, 
0x5D, 0x5D, 0x00, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x2D, 0x2E, 0x01, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
0x1F, 0x1F, 0x60, 0x60, 0x60, 0x60, 0x60, 0x1B, 0x60, 0x00, 0x00, 
0xF9, 0xF9, 0xF9, 0xF9, 0xF9, 0x5D, 0x5D, 0x5D, 0x00, 0xA3, 0xA3, 
0xA3, 0x5A, 0x5A, 0x2D, 0x2E, 0x2D, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x86, 0x86, 0x1F, 0x1F, 
0x60, 0x60, 0x60, 0x60, 0x60, 0x1B, 0x26, 0x28, 0x00, 0xF9, 0xF9, 
0xF9, 0x5D, 0x5D, 0x00, 0xA3, 0xA3, 0xA3, 0x5A, 0x5A, 0x2D, 0x2E, 
0x2D, 0x2D, 0x29, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0x00, 0x86, 0x86, 0x86, 0x86, 0x1F, 0x1F, 0x60, 0x60, 
0x60, 0xD5, 0xD5, 0x28, 0x27, 0x01, 0x00, 0xF9, 0x5D, 0x00, 0x5A, 
0x5A, 0xA3, 0x5A, 0x5A, 0x2D, 0x2E, 0x2D, 0x2D, 0x2E, 0x01, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x86, 
0x86, 0x86, 0x86, 0x86, 0x86, 0x1F, 0x1F, 0xD5, 0xD5, 0xD5, 0x27, 
0x28, 0x00, 0xCA, 0x01, 0x00, 0xCA, 0xA3, 0xA3, 0x1F, 0x1F, 0x2D, 
0x2D, 0x2E, 0x2D, 0x2D, 0x2E, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x86, 0x86, 0x86, 0x86, 0x86, 
0x86, 0x86, 0x86, 0x08, 0xD4, 0xD5, 0x28, 0x28, 0x00, 0xCA, 0xCA, 
0xCA, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x2D, 0x2D, 0x2E, 0x2D, 0x2D, 
0x2E, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0x00, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x08, 
0xD4, 0xD5, 0xD5, 0x28, 0x00, 0xCA, 0xCA, 0xA3, 0xA3, 0xA3, 0xA3, 
0xA3, 0xA3, 0x2D, 0x2D, 0x2E, 0x2D, 0x2D, 0x2E, 0x00, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x86, 0x86, 
0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x08, 0xD4, 0xD5, 0xD5, 0x28, 
0x00, 0xCA, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x2D, 0x2D, 
0x2E, 0x2D, 0x2D, 0x2E, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 
0x86, 0x86, 0x08, 0xD4, 0xD5, 0xD5, 0xD5, 0x00, 0xA3, 0xA3, 0xA3, 
0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x2D, 0x2D, 0x2E, 0x2D, 0x2D, 0x2E, 
0x00, 0x11, 0x11, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0x00, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0xD5, 0xD5, 
0xD5, 0xD5, 0xD5, 0x01, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 
0xA3, 0x2D, 0x2D, 0x2D, 0x2E, 0x2D, 0x00, 0x11, 0x11, 0x11, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x86, 0x86, 
0x86, 0x86, 0x86, 0x86, 0x86, 0xD5, 0xD5, 0xD5, 0xD5, 0x01, 0x00, 
0x00, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x2D, 0x2D, 0x2E, 
0x2D, 0x00, 0x11, 0x11, 0x11, 0x11, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x86, 0x86, 0x86, 0x86, 
0x86, 0xD5, 0xD5, 0xD5, 0x01, 0x11, 0x11, 0x11, 0x00, 0x00, 0xA3, 
0xA3, 0xA3, 0xA3, 0xA3, 0x2D, 0x2D, 0x2E, 0x00, 0x11, 0x11, 0x11, 
0x11, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x86, 0x86, 0x86, 0xD5, 0xD5, 0x01, 
0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0xA3, 0xA3, 0xA3, 
0x2D, 0x2E, 0x00, 0x11, 0x11, 0x11, 0x11, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0x00, 0x00, 0x86, 0xD5, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 
0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xA3, 0x2D, 0x00, 0x11, 0x11, 
0x11, 0x11, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};
static const char menu_template[] = 
"   MENU 'Edit'"
"     ITEM 'Add a monster child' 'CMD=ADDBIGCHILD'"
"     ITEM 'Add a child' 'CMD=ADDCHILD'"
"     ITEM 'Add a sibling' 'CMD=ADDSIB'"
"     ITEM 'Clear' 'CMD=CLEAR'"
"     SEPARATOR"
"     ITEM 'Select all' 'CMD=SELECTALL'"
"     ITEM 'Deselect all' 'CMD=DESELECTALL'"
"     SEPARATOR"
"     ITEM 'Toggle boredom value' 'CMD=TOGGLEBORING'"
"   END";

#define TREELIST_MESSAGE 69

static BBitmap* bigmap;
static BBitmap* selbigmap;

class BigItem : public TreeItem
{
	public:
		BigItem( const char* name) : TreeItem( name) {}
		float Height() const { return 2.0 * inherited::Height(); }
		const BBitmap* Icon() const;
};

const BBitmap* BigItem::Icon() const
{
	return isSelected() ? selbigmap : bigmap; 
}

void main()
{
	TreeApp app;
	app.Run();
}


static TreeItem* CreateItem( bool big)
{
	TreeItem* item;
	static int createcount = 0;
	char buff[50];
	
	sprintf( buff, "Itemy %d", ++createcount);

	if (big)
		item = new BigItem(buff);
	else
		item = new TreeItem( buff);
		
	return item;	
}

const char* TreeWindow::MenuTemplate()
{
	return menu_template;
}

BaseView* TreeWindow::CreateView(BRect r)
{ 
	TView* v = new TView(r);
	tv = v->GetTree();
	return v;
}

void TreeWindow::MessageReceived( BMessage* m)
{
	switch( m->what)
	{
		case TREELIST_MESSAGE:
			long event = m->FindLong("t_event");
			LogPrintf( "Tree test", LOGGER_INFORMATIONAL, "Got tree control event %ld", event);
			TreeList* list = (TreeList*)m->FindObject("source");
			
			if ( list == tv)
				LogPuts( "Tree test", LOGGER_INFORMATIONAL, "Pointer to TreeList OK");				

			TreeItem*  item = (TreeItem*)m->FindObject("t_item");
			
			if ( item)
				LogPuts( "Tree item was:", LOGGER_INFORMATIONAL, item->Label());
			else
				LogPuts( "Tree item was:", LOGGER_INFORMATIONAL, "missing");
			

			break;
			
		default:
			inherited::MessageReceived(m);	
	}	
}

void TreeWindow::MenuCommand( BMessage& message)
{
	const char* cmd = message.FindString("CMD");
	
	if ( strcmp( cmd, "CLEAR") == 0)
	{
		TreeItem* item;
		while( item = tv->GetSelected() )
		{
			tv->RemoveItem(item);
			item->DeleteChildren();
			delete item;
		}
	}
	else if ( strcmp( cmd, "SELECTALL") == 0)
	{
		tv->SelectAll(TRUE);
	}
	else if ( strcmp( cmd, "DESELECTALL") == 0)
	{
		tv->SelectAll(FALSE);
	}
	else if ( strcmp( cmd, "ADDSIB") == 0)
	{
		TreeItem* item = tv->Current();
		if ( item)
		{
			item->AddSibling(CreateItem(FALSE));
			// tv->Refresh(true);
		}
		else
		{
			tv->AddItem( CreateItem(FALSE));
		}	
	}
	else if ( strcmp( cmd, "ADDCHILD") == 0)
	{
		TreeItem* item = tv->Current();
		if ( item)
		{
			item->AddChild(CreateItem(FALSE));
			// tv->Refresh(true);
		}
		else
		{
			tv->AddItem( CreateItem(FALSE));
		}	
	}
	else if ( strcmp( cmd, "ADDBIGCHILD") == 0)
	{
		TreeItem* item = tv->Current();
		if ( item)
		{
			item->AddChild(CreateItem(TRUE));
			// tv->Refresh(true);
		}
		else
		{
			tv->AddItem( CreateItem(TRUE));
		}	
	}
	else if ( strcmp( cmd, "TOGGLEBORING") == 0)
	{
		tv->SetBoring(!tv->Boring());
	}
}



TView::TView(BRect f) : BaseView(f), message(new BMessage(TREELIST_MESSAGE))
{
	bigmap = new BBitmap( BRect(0,0,36,33), B_COLOR_8_BIT);
	::memcpy( bigmap->Bits(), bigmap_data, bigmap->BitsLength());
	selbigmap = TreeItem::CreateDimBitmap(bigmap);
	
	TreeItem* item1 = CreateItem( FALSE);
	TreeItem* item2 = CreateItem( FALSE);
	TreeItem* item3 = CreateItem( FALSE);
	TreeItem* item4 = CreateItem( FALSE);
	TreeItem* item5 = CreateItem( FALSE);
	TreeItem* item6 = CreateItem( FALSE);
	TreeItem* item7 = CreateItem( FALSE);
	TreeItem* item8 = CreateItem( FALSE);
	
	// Build tree items into 2 trees
	//
	item1->AddChild( item3);
	item1->AddFirstChild( item2);
		item3->AddChild( item4);
	item5->AddChild( item6);
	item5->AddChild( item7);
	item5->AddChild( item8);
	
	f.OffsetTo( 0, 0);
	tree = new TreeList( f, "name", "label", message, B_FOLLOW_ALL);
	tree->AddItem( item1);
	tree->AddItem( item5);
	AddChild( tree);
	
	tree->MakeFocus();
}

